// ==UserScript==
// @name         5ch 板一覧
// @namespace    http://tampermonkey.net/
// @version      0.81
// @description  左側に板一覧を作成
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        GM_xmlhttpRequest
// @grant        GM_addStyle
// @connect      menu.5ch.net
// ==/UserScript==

(function() {
    'use strict';

    // 1. id="hideme" を id="sidemenu" に書き換え
    const oldId = 'hideme';
    const newId = 'sidemenu';
    const oldElem = document.getElementById(oldId);
    if (!oldElem) return;
    oldElem.id = newId;

    // overleftを削除
    const overleftElem = document.getElementById('overleft');
    if (overleftElem) overleftElem.remove();

    // 余分な<hr>を削除
    const hrs = document.querySelectorAll('hr');
    if (hrs.length >= 3) {
        hrs[1].remove(); // 2つ目
        hrs[2].remove(); // 3つ目（2つ目削除後も元の3つ目が3番目のindexとして残る）
    }

    // 2. sidemenu の中に id="bbsmenu" の新しいコンテナを作成
    let bbsmenu = document.createElement('div');
    bbsmenu.id = 'bbsmenu';
    bbsmenu.innerHTML = '<div class="tree"><ul></ul></div>';
    oldElem.appendChild(bbsmenu);

    // 3. CSS設定（最上位ulは常に表示、軽量＆強制上書き）
    GM_addStyle(`
:root {
    --bg-dark: #212425;
    --bg-darker: #1e1e1e;
    --bg-darkest: #1a1a1a;
    --text-main: #e0e0e0;
    --text-muted: #aabbcc;
    --text-link: #80cbc4;
    --text-link-hover: #a7ffeb;
    --border-color: #333;
    --white: #ffffff;
}

#sidemenu, #bbsmenu, .tree, .tree ul {
    margin: 0;
    padding: 0;
    list-style: none;
    font-family: inherit;
    font-size: 1em;
    background-color: var(--bg-dark) !important;
    color: var(--text-main) !important;
}

.tree > ul {
    display: block !important;
}

.tree ul {
    display: none;
    margin-left: 1em;
    background-color: var(--bg-dark) !important;
}

.tree li.open > ul {
    display: block !important;
}

.tree li {
    margin: 2px 0;
    border-radius: 4px;
    background-color: var(--bg-darker) !important;
    position: relative;
    color: var(--text-main) !important;
    transition: background-color 0.2s ease;
}

.tree li > a::before {
    content: none;
}

.tree li > a {
    display: block;
    padding: 4px 8px 4px 1.5em;
    color: var(--text-link) !important;
    text-decoration: none;
    background-color: inherit !important;
    user-select: text;
    position: relative;
}

.tree li > a:hover {
    background-color: var(--bg-darkest) !important;
    color: var(--text-link-hover) !important;
    text-decoration: underline;
}

.tree li::before {
    position: absolute;
    left: 0.5em;
    top: 0.45em;
    font-size: 0.85em;
    color: var(--text-muted);
    pointer-events: none;
}

.tree li.closed::before {
    content: "▶";
}

.tree li.open::before {
    content: "▼";
}

.tree li.closed {
    background-color: var(--bg-darker) !important;
    color: var(--text-main) !important;
}

.tree li.closed > ul {
    background-color: var(--bg-dark) !important;
}

.tree li.closed > ul > li {
    background-color: var(--bg-darker) !important;
    color: var(--text-main) !important;
}

/* 交互背景色の無効化 */
.tree li:nth-child(odd),
.tree li:nth-child(even),
.tree li > ul > li:nth-child(odd),
.tree li > ul > li:nth-child(even) {
    background-color: var(--bg-darker) !important;
    color: var(--text-main) !important;
}
    `);

    // 4. 板一覧HTML取得・解析・表示
    GM_xmlhttpRequest({
        method: 'GET',
        url: 'https://menu.5ch.net/bbstable.html',
        onload: function(res) {
            if(res.status !== 200) {
                bbsmenu.innerText = '板一覧の取得中にエラーが発生しました。';
                return;
            }
            const parser = new DOMParser();
            const doc = parser.parseFromString(res.responseText, 'text/html');

            const font = doc.querySelector('font[size="2"]');
            if (!font) {
                bbsmenu.innerText = '板一覧の取得に失敗しました。構造が変わっている可能性があります。';
                return;
            }

            let treeRoot = bbsmenu.querySelector('ul');
            let currentCategory = null;

            let nodes = Array.from(font.childNodes);
            for(let i = 0; i < nodes.length; i++) {
                let node = nodes[i];

                if(node.nodeType === Node.TEXT_NODE && node.textContent.trim() === '【') {
                    let bNode = nodes[i+1];
                    let closeBracket = nodes[i+2];
                    if(bNode && bNode.nodeType === Node.ELEMENT_NODE && bNode.tagName === 'B' &&
                       closeBracket && closeBracket.nodeType === Node.TEXT_NODE && closeBracket.textContent.trim() === '】') {
                        let catName = bNode.textContent.trim();
                        currentCategory = document.createElement('li');
                        currentCategory.textContent = catName;
                        let childUl = document.createElement('ul');
                        currentCategory.appendChild(childUl);
                        treeRoot.appendChild(currentCategory);
                        i += 2;
                        continue;
                    }
                }
                else if(node.nodeType === Node.ELEMENT_NODE && node.tagName === 'A') {
                    if(currentCategory) {
                        let childUl = currentCategory.querySelector('ul');
                        let li = document.createElement('li');
                        let a = document.createElement('a');
                        a.href = node.href;
                        a.textContent = node.textContent;
                        a.target = '_blank';
                        li.appendChild(a);
                        childUl.appendChild(li);
                    } else {
                        let li = document.createElement('li');
                        let a = document.createElement('a');
                        a.href = node.href;
                        a.textContent = node.textContent;
                        a.target = '_blank';
                        li.appendChild(a);
                        treeRoot.appendChild(li);
                    }
                }
            }

            // 5. トグル機能追加
            addToggle(bbsmenu.querySelector('.tree'));

            // 板一覧全体をトグルする見出し追加
            const toggleHeader = document.createElement('div');
            toggleHeader.textContent = '▶ 板一覧'; // 初期は閉じた状態
            toggleHeader.id = 'bbsmenu-toggle';
            toggleHeader.style.cursor = 'pointer';
            toggleHeader.style.padding = '6px 12px';
            toggleHeader.style.backgroundColor = 'var(--bg-dark)';
            toggleHeader.style.color = 'var(--text-link)';
            toggleHeader.style.fontWeight = 'bold';
            toggleHeader.style.userSelect = 'none';

            // .tree を取得して初期非表示
            const treeContainer = bbsmenu.querySelector('.tree');
            treeContainer.style.display = 'none'; // 初期状態は非表示

            let isOpen = false;
            toggleHeader.addEventListener('click', () => {
                isOpen = !isOpen;
                treeContainer.style.display = isOpen ? 'block' : 'none';
                toggleHeader.textContent = (isOpen ? '▼' : '▶') + ' 板一覧';
            });

            // .tree の直前に見出しを挿入
            bbsmenu.insertBefore(toggleHeader, treeContainer);

        },
        onerror: function() {
            bbsmenu.innerText = '板一覧の取得中にエラーが発生しました。';
        }
    });

    // 6. 展開・折りたたみ機能
    function addToggle(treeRoot) {
        treeRoot.querySelectorAll('li').forEach(li => {
            let childUl = li.querySelector('ul');
            if(childUl) {
                li.classList.add('closed');
                li.addEventListener('click', e => {
                    if(e.target.tagName === 'A') return;
                    e.stopPropagation();
                    li.classList.toggle('open');
                });
            }
        });
    }
})();
